/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.ui;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.ui.UILog;
import com.ibm.hwmca.fw.ui.UIStyle;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class UIStyleManager
implements UILog {
    private static final String PLUGINS_PATH = "plugins";
    private static final String UISTYLES_PATH = "uistyles/";
    private static final String DEFAULT_STYLE_FILE = "data/defaultuserpref.properties";
    private static final String DEFAULT_STYLE_KEY = "uistyle.defaultid";
    private static UIStyleManager instance;
    private static final String TRACE_MASKT = "HUISM  T";
    private static final String TRACE_MASKF = "HUISM  F";
    private static final String TRACE_MASKD = "HUISM  D";

    private UIStyleManager() {
    }

    public static UIStyleManager getUIStyleManager() {
        if (instance == null) {
            instance = new UIStyleManager();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public UIStyle getDefaultUIStyle() {
        UIStyle style;
        block14: {
            Trace.trace(TRACE_MASKT, "-> UIStyleManager.getDefaultStyle()");
            style = null;
            FileInputStream propsFis = null;
            FileInputStream defaultFis = null;
            File file = new File(DEFAULT_STYLE_FILE);
            Properties props = new Properties();
            propsFis = new FileInputStream(file);
            props.load(propsFis);
            String towerPluginsPath = BaseFileControl.getFilePath(PLUGINS_PATH);
            String fileName = towerPluginsPath + UISTYLES_PATH + props.getProperty(DEFAULT_STYLE_KEY);
            File defaultFile = new File(fileName);
            defaultFis = new FileInputStream(defaultFile);
            byte[] b = new byte[(int)defaultFile.length()];
            defaultFis.read(b);
            style = this.newInstance(new String(b));
            Object var11_12 = null;
            try {
                if (propsFis != null) {
                    propsFis.close();
                }
                if (defaultFis != null) {
                    defaultFis.close();
                }
                break block14;
            }
            catch (IOException ioexc) {
                new FrameworkLog(UILog.logInfo, 1812, ioexc).log();
            }
            break block14;
            {
                catch (Exception exc) {
                    Trace.trace(TRACE_MASKF, exc);
                    HException hexc = null;
                    hexc = exc instanceof HException ? (HException)exc : new HException(exc);
                    new FrameworkLog(UILog.logInfo, 1809, hexc).log();
                    Object var11_13 = null;
                    try {
                        if (propsFis != null) {
                            propsFis.close();
                        }
                        if (defaultFis != null) {
                            defaultFis.close();
                        }
                        break block14;
                    }
                    catch (IOException ioexc) {
                        new FrameworkLog(UILog.logInfo, 1812, ioexc).log();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                try {
                    if (propsFis != null) {
                        propsFis.close();
                    }
                    if (defaultFis != null) {
                        defaultFis.close();
                    }
                }
                catch (IOException ioexc) {
                    new FrameworkLog(UILog.logInfo, 1812, ioexc).log();
                }
                throw throwable;
            }
        }
        Trace.trace(TRACE_MASKT, "<- UIStyleManager.getDefaultStyle()");
        return style;
    }

    public List getUIStyles() {
        return this.discover();
    }

    private List discover() {
        ArrayList<UIStyle> styles;
        block13: {
            Trace.trace(TRACE_MASKF, "-> UIStyleManager.discover()");
            styles = new ArrayList<UIStyle>();
            try {
                String towerPluginsPath = BaseFileControl.getFilePath(PLUGINS_PATH) + UISTYLES_PATH;
                File directory = new File(towerPluginsPath);
                if (directory.exists()) {
                    String[] fileNames = directory.list();
                    if (fileNames == null || fileNames.length == 0) {
                        String s = "Error, there are no files in directory [" + towerPluginsPath + "]";
                        throw new HException(s);
                    }
                    for (int i = 0; i < fileNames.length; ++i) {
                        File file = new File(towerPluginsPath + fileNames[i]);
                        if (file.isDirectory()) {
                            Trace.trace(TRACE_MASKF, "Searching for user style files, skipping directory: " + towerPluginsPath + fileNames[i]);
                            continue;
                        }
                        FileInputStream fis = null;
                        try {
                            fis = new FileInputStream(file);
                            byte[] b = new byte[(int)file.length()];
                            fis.read(b);
                            UIStyle style = this.newInstance(new String(b));
                            if (this.isIdentifierUnique(style, styles)) {
                                styles.add(style);
                                continue;
                            }
                            String s = "Error: user interface style " + style + " from file name " + fileNames[i] + " was previously defined.";
                            throw new HException(s);
                        }
                        catch (IOException exc) {
                            String s = "Error trying read file [" + fileNames[i] + "]";
                            HException hexc = new HException(exc);
                            hexc.add(s);
                            throw hexc;
                        }
                        finally {
                            if (fis != null) {
                                fis.close();
                            }
                        }
                    }
                    break block13;
                }
                String s = "Error, could not find directory [" + towerPluginsPath + "]";
                throw new HException(s);
            }
            catch (Exception exc) {
                Trace.trace(TRACE_MASKF, exc);
                HException hexc = null;
                hexc = exc instanceof HException ? (HException)exc : new HException(exc);
                new FrameworkLog(UILog.logInfo, 1811, hexc).log();
            }
        }
        Trace.trace(TRACE_MASKF, "<- UIStyleManager.discover()");
        return styles;
    }

    private UIStyle newInstance(String className) throws HException {
        UIStyle uiStyle = null;
        if ((className = className.trim()).charAt(className.length() - 1) == '\n') {
            className = className.substring(0, className.length() - 2);
        }
        Trace.trace(TRACE_MASKF, "User Style object class name is [" + className + "]");
        try {
            Class<?> c = Class.forName(className);
            uiStyle = (UIStyle)c.newInstance();
        }
        catch (Exception exc) {
            String s = "Error trying to instantiate class [" + className + "]";
            HException hexc = new HException(exc);
            hexc.add(s);
            throw hexc;
        }
        return uiStyle;
    }

    private boolean isIdentifierUnique(UIStyle style, List styles) {
        boolean result = true;
        String identifier = style.getIdentifier();
        Iterator iterator = styles.iterator();
        while (iterator.hasNext() && result) {
            UIStyle next = (UIStyle)iterator.next();
            if (!identifier.equals(next.getIdentifier())) continue;
            result = false;
        }
        return result;
    }
}

